#include <stdio.h>
#include <windows.h>
#include "resource.h"

//\
//vOC\
typedef struct {
    CHAR	PluginName[32];
    CHAR	PluginVersion[16];
    CHAR	PluginComment[256];
    CHAR	PluginCopyright[128];
    CHAR	PluginURL[256];
    CHAR	PluginMail[256];
    INT		PluginFuncNum;
    INT		PluginInfoFlag;
    INT		Reserved;
} tagPluginInfo, *LPPLUGININFO;

//tO
#define PLUGIN_INFOFLAG_DEFAULT			0		//ɖ
#define PLUGIN_INFOFLAG_SHOWSETTING		1		//ݒ_CAOL
#define PLUGIN_INFOFLAG_SHOWABOUT		2		//_CAOL

//vOC@\\
typedef struct {
    CHAR	FuncName[32];
    CHAR	FuncComment[256];
    INT		FuncSettingNum;
    INT		FuncInfoFlag;
    INT		Reserved;
} tagPluginFuncInfo, *LPPLUGINFUNCINFO;

//tO
#define PLUGINFUNC_INFOFLAG_DEFAULT			0	//ɖ
#define PLUGINFUNC_INFOFLAG_UNICODE			1	//Unicodeo
#define PLUGINFUNC_INFOFLAG_NOSETTINGDLG	2	//ݒ_CAO

//ݒP
typedef struct {
	CHAR	SettingName[128];
	CHAR	ViewText[256];
} tagFunc1SettingInfo, *LPFUNC1SETTINGINFO;

//ݒQ
typedef struct {
	WCHAR	SettingName[128];
	WCHAR	ViewText[256];
} tagFunc2SettingInfo, *LPFUNC2SETTINGINFO;

/* GNX|[gp֐ */
#define MWCP_API __declspec(dllexport)
MWCP_API INT  __stdcall Init();
MWCP_API VOID __stdcall Free();
MWCP_API VOID __stdcall ShowAbout(HWND hWnd);
MWCP_API VOID __stdcall ShowSetting(int FuncNo, int SettingNo, HWND hWnd);
MWCP_API INT  __stdcall GetText(int FuncNo, int SettingNo, HWND ActivateWnd, LPSTR Buff, int cch, int Reserved);
MWCP_API VOID __stdcall GetInfo(LPPLUGININFO dstPluginInfo);
MWCP_API VOID __stdcall GetFuncInfo(int FuncNo, LPPLUGINFUNCINFO dstFuncInfo);
MWCP_API INT  __stdcall GetFuncSettingName(int FuncNo, int SettingNo, char* SettingName, int cch);

//֐vg^Cv
BOOL CALLBACK SettingDialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
VOID SaveSetting_Func1();
VOID SaveSetting_Func2();

//O[oe[u
#define PLUGIN_FUNCNUM		3	//@\FR
//vOC
tagPluginInfo PluginInfo = {
	"TvvOC",				/* vOC */
	"Ver 0.0.0",						/* o[W */
	"TvvOCłB",			/* Rg */
	"(c)2007 Goroxo",					/* 쌠 */
	"http://www.entiapage.com/",		/* URL */
	"goroxo@entiapage.com",				/* [AhX */
	PLUGIN_FUNCNUM,						/* @\ */
	PLUGIN_INFOFLAG_DEFAULT,			/* tO */
	NULL								/* \ */
};

#define FUNC1_SETTINGNUM	5	//@\1ݒ萔FT
#define FUNC2_SETTINGNUM	5	//@\2ݒ萔FT
#define FUNC3_SETTINGNUM	2	//@\3ݒ萔FQ
//e@\
tagPluginFuncInfo PluginFuncInfo[PLUGIN_FUNCNUM] = {
	{
		"Œ蕶\(SJIS)",				/* @\ */
		"w肵\܂B\r\n"
		"Shift-JISɑΉĂ܂B",		/* Rg */
		FUNC1_SETTINGNUM,					/* ݒ萔 */
		PLUGINFUNC_INFOFLAG_DEFAULT,		/* tO:ʏ */
		NULL								/* \ */
	},
	{
		"Œ蕶\(Unicode)",			/* @\ */
		"w肵\܂B\r\n"
		"UnicodeɑΉĂ܂B",		/* Rg */
		FUNC2_SETTINGNUM,					/* ݒ萔 */
		PLUGINFUNC_INFOFLAG_UNICODE,		/* tO:Unicode */
		NULL								/* \ */
	},
	{
		"EChEnh\",			/* @\ */
		"\Ώۂ̃EChEnh"
		"\܂B",						/* Rg */
		FUNC3_SETTINGNUM,					/* ݒ萔 */
		PLUGINFUNC_INFOFLAG_NOSETTINGDLG,	/* tO:ݒύX */
		NULL								/* \ */
	}
};

//O[oϐ
HINSTANCE hInstance;
BOOL fInitFlag = FALSE;
BOOL fQuitFlag = FALSE;
//eݒ
tagFunc1SettingInfo Func1Settings[FUNC1_SETTINGNUM];
tagFunc2SettingInfo Func2Settings[FUNC2_SETTINGNUM];

//DLLC
//ɃpX擾ׁACX^X擾ĂB
BOOL APIENTRY DllMain( HINSTANCE hInst, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			hInstance = hInst;
			break;
		case DLL_THREAD_ATTACH:
			break;
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
			if(!fQuitFlag){
				Free();
			}
			break;
    }
    return TRUE;
}

//vOC
//SJISłUnicodeł̐ݒǂݍށB
MWCP_API INT _stdcall Init()
{
	CHAR strPath[MAX_PATH];				/* vOCpX */
	WCHAR wstrPath[MAX_PATH];			/* vOCpX */
	CHAR strSettingPath[MAX_PATH];		/* ݒt@CpX */
	WCHAR wstrSettingPath[MAX_PATH];	/* ݒt@CpX */
	INT i;								/* ėpJE^ */
	LPSTR strret;						/* ėp|C^ */
	PWSTR wstrret;						/* ėp|C^ */

	CHAR strApp[32];					/* ݒt@C̃ZNV */
	CHAR strDef[256];					/* ݒt@CEftHg */

	/* vOC̃t@C擾 */
	GetModuleFileName(hInstance, strPath, sizeof(strPath));
	GetModuleFileNameW(hInstance, wstrPath, sizeof(wstrPath) / sizeof(WCHAR));
	/* t@CpX擾 */
	strret = strrchr(strPath, (INT)'\\');
	strPath[strret - strPath + 1] = '\0';
	wstrret = wcsrchr(wstrPath, L'\\');
	wstrPath[wstrret - wstrPath + 1] = L'\0';

	/* ݒt@CpX𐶐 */
	strcpy(strSettingPath, strPath);
	strcat(strSettingPath, "TestPlugin\\Func1Setting.ini");
	wcscpy(wstrSettingPath, wstrPath);
	wcscat(wstrSettingPath, L"TestPlugin\\Func2Setting.ini");

	/* ݒǂݍ */
	for(i=0; i < FUNC1_SETTINGNUM; i++){
		/* ZNV */
		sprintf(strApp, "Setting%03d", i);
		/* ݒ薼 */
		sprintf(strDef, "ݒ%03d", i+1);
		GetPrivateProfileString(strApp, "SettingName", strDef, Func1Settings[i].SettingName, 128, strSettingPath);
		/* \ */
		strcpy(strDef, "\"\"");
		GetPrivateProfileString(strApp, "Text", NULL, Func1Settings[i].ViewText, 256, strSettingPath);
	}

	for(i=0; i < FUNC2_SETTINGNUM; i++){
		/* ZNV */
		swprintf((PWSTR)strApp, L"Setting%03d", i);
		/* ݒ薼 */
		swprintf((PWSTR)strDef, L"ݒ%03d", i+1);
		GetPrivateProfileStringW((PWSTR)strApp, L"SettingName", (PWSTR)strDef, Func2Settings[i].SettingName, 128, wstrSettingPath);
		/* \ */
		wcscpy((PWSTR)strDef, L"\"\"");
		GetPrivateProfileStringW((PWSTR)strApp, L"Text", NULL, Func2Settings[i].ViewText, 256, wstrSettingPath);
	}
	return 0;
}

//I
MWCP_API VOID _stdcall Free()
{
	fQuitFlag = TRUE;
}

//o[W\
MWCP_API VOID __stdcall ShowAbout(HWND hWnd)
{
	MessageBox(hWnd, "gv TvvOC Ver.0.0.0", "gv", NULL);
}

//ݒʕ\
MWCP_API VOID __stdcall ShowSetting(int FuncNo, int SettingNo, HWND hWnd)
{
	LPARAM lParam;
	if(FuncNo == 1 || FuncNo == 2){
		lParam = (LPARAM)(((WORD)FuncNo << 16) | (WORD)SettingNo);		/* @\ԍEݒԍAĊi[A_CAOɓn */
		DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_SETTING), hWnd, (DLGPROC)SettingDialogProc, lParam);
	}
	return;
}

//ݒ_CAO
BOOL CALLBACK SettingDialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam){
	CHAR szTmp[5];
	INT FuncNo, SetNo;			/* @\ԍEݒԍ */
	switch(uMsg){
	case WM_INITDIALOG:		/* _CAO */
		FuncNo = (INT)(WORD)((lParam & 0xFFFF0000) >> 16);		/* 󂯎p[^@\ԍ擾 */
		SetNo = (INT)(WORD)(lParam & 0x0000FFFF);				/* 󂯎p[^ݒԍ擾 */
		sprintf(szTmp, "%d", FuncNo);							/* @\ԍێĂ */
		SetWindowText(GetDlgItem(hwndDlg, IDC_STATIC_FUNCNO), szTmp);
		sprintf(szTmp, "%d", SetNo);							/* ݒԍێĂ */
		SetWindowText(GetDlgItem(hwndDlg, IDC_STATIC_SETTINGNO), szTmp);

		if(FuncNo == 1)		//SJIS
		{
			SetWindowText(GetDlgItem(hwndDlg, IDC_EDIT_SETTINGNAME), Func1Settings[SetNo - 1].SettingName);
			SetWindowText(GetDlgItem(hwndDlg, IDC_EDIT_TEXT), Func1Settings[SetNo - 1].ViewText);
		}else{				//Unicode
			SetWindowTextW(GetDlgItem(hwndDlg, IDC_EDIT_SETTINGNAME), Func2Settings[SetNo - 1].SettingName);
			SetWindowTextW(GetDlgItem(hwndDlg, IDC_EDIT_TEXT), Func2Settings[SetNo - 1].ViewText);
		}

		break;
	case WM_CLOSE:		/* _CAO悤Ƃ */
		/* _CAOI */
		EndDialog(hwndDlg, 0);
		return TRUE;
		break;
	case WM_COMMAND:	/* eRg[쎞 */
		/* ǂ̃Rg[𑀍삵H */
		switch( LOWORD( wParam) ){
		case IDOK:					/* OK{^ */
			/* @\ԍ擾 */
			GetWindowText(GetDlgItem(hwndDlg, IDC_STATIC_FUNCNO), szTmp, 5);
			FuncNo = atoi(szTmp);
			/* ݒԍ擾 */
			GetWindowText(GetDlgItem(hwndDlg, IDC_STATIC_SETTINGNO), szTmp, 5);
			SetNo = atoi(szTmp);
			
			if(FuncNo == 1)		//SJIS
			{
				GetWindowText(GetDlgItem(hwndDlg, IDC_EDIT_SETTINGNAME), Func1Settings[SetNo - 1].SettingName, 128);
				GetWindowText(GetDlgItem(hwndDlg, IDC_EDIT_TEXT), Func1Settings[SetNo - 1].ViewText, 256);
			}else{				//Unicode
				GetWindowTextW(GetDlgItem(hwndDlg, IDC_EDIT_SETTINGNAME), Func2Settings[SetNo - 1].SettingName, 128);
				GetWindowTextW(GetDlgItem(hwndDlg, IDC_EDIT_TEXT), Func2Settings[SetNo - 1].ViewText, 256);
			}
			/* ݒۑ */
			if(FuncNo == 1)			//SJIS
			{
				SaveSetting_Func1();
			}else{					//Unicode
				SaveSetting_Func2();
			}

			/* _CAOI */
			EndDialog(hwndDlg, 0);
			return TRUE;
			break;
		case IDCANCEL:					/* LZ{^ */
			/* _CAOI */
			EndDialog(hwndDlg, 0);
			return TRUE;
			break;
		}
		break;
	}
	return 0;
}

/* ݒۑFSJIS */
VOID SaveSetting_Func1(){
    CHAR strPath[MAX_PATH];				/* vOCpX */
	CHAR strSettingPath[MAX_PATH];		/* ݒt@CpX */
	INT i;								/* ėpJE^ */
	LPSTR strret;						/* ėp|C^ */

	CHAR strApp[16];					/* ݒt@C̃ZNV */
	CHAR strTmp[1024];					/* e| */

	/* vOC̃t@C擾 */
	GetModuleFileName(hInstance, strPath, sizeof(strPath));
	/* t@CpX擾 */
	strret = strrchr(strPath, (INT)'\\');
	strPath[strret - strPath + 1] = '\0';

	/* ݒt@CpX𐶐 */
	strcpy(strSettingPath, strPath);
	strcat(strSettingPath, "TestPlugin\\Func1Setting.ini");

	/* ݒۑ */
	for(i=0; i < FUNC1_SETTINGNUM; i++){
		/* ZNV */
		sprintf(strApp, "Setting%03d", i);
		/* ݒ薼 */
		WritePrivateProfileString(strApp, "SettingName", Func1Settings[i].SettingName, strSettingPath);
		/* \ */
		sprintf(strTmp, "\"%s\"", Func1Settings[i].ViewText);
		WritePrivateProfileString(strApp, "Text", strTmp, strSettingPath);
	}
}

/* ݒۑFUnicode */
VOID SaveSetting_Func2(){
    WCHAR strPath[MAX_PATH];			/* vOCpX */
	WCHAR strSettingPath[MAX_PATH];		/* ݒt@CpX */
	INT i;								/* ėpJE^ */
	PCWSTR strret;						/* ėp|C^ */

	WCHAR strApp[16];					/* ݒt@C̃ZNV */
	WCHAR strTmp[1024];					/* e| */
	HANDLE hFile;

	/* vOC̃t@C擾 */
	GetModuleFileNameW(hInstance, strPath, sizeof(strPath));
	/* t@CpX擾 */
	strret = wcsrchr(strPath, L'\\');
	strPath[strret - strPath + 1] = L'\0';

	/* ݒt@CpX𐶐 */
	wcscpy(strSettingPath, strPath);
	wcscat(strSettingPath, L"TestPlugin\\Func2Setting.ini");

	/* t@CJA݂mF */
	hFile = CreateFileW(strSettingPath, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hFile != INVALID_HANDLE_VALUE){
		CloseHandle(hFile);
	}else{
		/* t@C݂ȂꍇA\BOM񂾃t@Cpӂ */
		hFile = CreateFileW(strSettingPath, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		BYTE BOM[2] = {0xFF, 0xFE};
		DWORD size;
		if (hFile == INVALID_HANDLE_VALUE) {
			return ;
		}
		WriteFile(hFile, BOM, 2, &size, NULL);
		CloseHandle(hFile);
	}

	/* ݒۑ */
	for(i=0; i < FUNC1_SETTINGNUM; i++){
		/* ZNV */
		swprintf(strApp, L"Setting%03d", i);
		/* ݒ薼 */
		WritePrivateProfileStringW(strApp, L"SettingName", Func2Settings[i].SettingName, strSettingPath);
		/* \ */
		swprintf(strTmp, L"\"%s\"", Func2Settings[i].ViewText);
		WritePrivateProfileStringW(strApp, L"Text", strTmp, strSettingPath);
	}
}

/* gvĂ΂A\擾 */
MWCP_API INT  __stdcall GetText(int FuncNo, int SettingNo, HWND ActivateWnd, LPSTR Buff, int cch, int Reserved)
{
	CHAR szTmp[12];
	switch(FuncNo){
	case 1:	/* SJISŌŒ蕶\ */
		if(SettingNo > 0 && SettingNo <= PluginFuncInfo[FuncNo-1].FuncSettingNum){
			if(cch != 0){
				strncpy(Buff, Func1Settings[SettingNo-1].ViewText, cch);
			}
			return strlen(Func1Settings[SettingNo-1].ViewText);
		}
		break;
	case 2:	/* UnicodeŌŒ蕶\ */
		if(SettingNo > 0 && SettingNo <= PluginFuncInfo[FuncNo-1].FuncSettingNum){
			if(cch != 0){
				wcsncpy((PWSTR)Buff, Func2Settings[SettingNo-1].ViewText, cch);
			}
			return wcslen(Func2Settings[SettingNo-1].ViewText);
		}
		break;
	case 3:	/* EChEnh擾 */
		if(SettingNo == 1){		/* 16i\L */
			szTmp[0] = '0';
			szTmp[1] = 'x';
			itoa((INT)ActivateWnd, szTmp + 2, 16);
		}else{					/* 10i\L */
			itoa((INT)ActivateWnd, szTmp, 10);
		}
		if(cch != 0){
			strncpy(Buff, szTmp, cch);
		}
		return strlen(szTmp);
		break;
	}
	return 0;
}

/* vOC擾 */
MWCP_API VOID __stdcall GetInfo(LPPLUGININFO dstPluginInfo)
{
	RtlMoveMemory(dstPluginInfo, &PluginInfo, sizeof(tagPluginInfo));
}

/* @\擾 */
MWCP_API VOID __stdcall GetFuncInfo(int FuncNo, LPPLUGINFUNCINFO dstFuncInfo)
{
	if(FuncNo > 0 && FuncNo <= PLUGIN_FUNCNUM)
		RtlMoveMemory(dstFuncInfo, &PluginFuncInfo[FuncNo - 1], sizeof(tagPluginFuncInfo));
}

/* ݒ薼擾 */
MWCP_API INT  __stdcall GetFuncSettingName(int FuncNo, int SettingNo, char* SettingName, int cch)
{
	INT len;
	LPSTR str;
	SettingName[0] = '\0';
	if(FuncNo > 0 && FuncNo <= PLUGIN_FUNCNUM){
		if(SettingNo > 0 && SettingNo <= PluginFuncInfo[FuncNo-1].FuncSettingNum){
			switch(FuncNo){
			case 1:
				strncpy(SettingName, Func1Settings[SettingNo-1].SettingName, cch);
				break;
			case 2:
				len = WideCharToMultiByte(CP_THREAD_ACP, 0, Func2Settings[SettingNo-1].SettingName, -1, NULL, 0, NULL, NULL);
				str = new CHAR[len];
				WideCharToMultiByte(CP_THREAD_ACP, 0, Func2Settings[SettingNo-1].SettingName, 
						wcslen(Func2Settings[SettingNo-1].SettingName) + 1, str, len, NULL,NULL);
				strncpy(SettingName, str, cch);
				delete[] str;
				break;
			case 3:
				switch(SettingNo){
				case 1:
					strncpy(SettingName, "16i\L", cch);
					break;
				case 2:
					strncpy(SettingName, "10i\L", cch);
					break;
				}
				break;
			}
		}
	}
	return strlen(SettingName);
}
