#include "stdafx.h"
#include "resource.h"

#include "Ranking.h"
#include <stdio.h>
#include <string.h>

void Ranking::WriteRanking()
{
	int i;
	char s[2];
	char s2[10];
	char filename[256];
	GetCurrentDirectory( 256 , filename);
	if(filename[strlen(filename)-1]!=(int)'\\')
		strcat(filename,"\\");
	strcat(filename,"Ranking.dat");
	for(i=0;i<MAX_RANKING;i++){
		sprintf(s,"%d",i+1);
		WritePrivateProfileString( s , "Name" , GetRankingName(i) , filename );
		sprintf(s2,"%d",GetRankingBody(i));
		WritePrivateProfileString( s , "Body" , s2 , filename );
		sprintf(s2,"%d",GetRankingScore(i));
		WritePrivateProfileString( s , "Score" , s2 , filename );
	}
}

void Ranking::ReadRanking()
{
	int i;
	char s[2];
	char filename[256];
	GetCurrentDirectory( 256 , filename);
	if(filename[strlen(filename)-1]!=(int)'\\')
		strcat(filename,"\\");
	strcat(filename,"Ranking.dat");
	for(i=0;i<MAX_RANKING;i++){
		sprintf(s,"%d",i+1);
		Score[i]=GetPrivateProfileInt( s , "Score" , 0 , filename );
		Body[i]=GetPrivateProfileInt( s , "Body" , 0 , filename );
		GetPrivateProfileString( s , "Name" , "No Name", Name[i] , 21 , filename );
	}
}

int Ranking::GetRank( int s )
{
	int i;
	for(i=0;i<MAX_RANKING;i++)
		if(Score[i]<s)
			return i+1;
	return 0;
}

void Ranking::SetRanking( int s , int b , char* n)
{
	int i,r;
	int w1s,w1b,w2s,w2b;
	char w1n[21],w2n[21];
	r=GetRank( s );
	if(r>0){
		r--;
		w1s=s;
		w1b=b;
		strcpy(w1n,n);
		for(i=r;i<MAX_RANKING;i++){
			w2s=Score[i];
			w2b=Body[i];
			strcpy(w2n,Name[i]);
			Score[i]=w1s;
			Body[i]=w1b;
			strcpy(Name[i],w1n);
			w1s=w2s;
			w1b=w2b;
			strcpy(w1n,w2n);
		}
	}
	WriteRanking();
}

void Ranking::ClearRanking()
{
	for(int i=0;i<MAX_RANKING;i++){
		Score[i]=0;
		Body[i]=0;
		strcpy( Name[i] , "No Name" );
	}
	WriteRanking();
}