// HebiGame.cpp : AvP[Vp̃Gg |Cg̒`
//

#include "stdafx.h"
#include "resource.h"
#include "Bitmap.h"
#include "Ranking.h"
#include "Hebi.h"
#include "Display.h"

#include <mmsystem.h>
#include <stdio.h>

#define MAX_LOADSTRING 100


// O[oϐ:
HINSTANCE hInst;					// ݂̃CX^X
TCHAR szTitle[MAX_LOADSTRING];				// ^Cg o[ eLXg
TCHAR szWindowClass[MAX_LOADSTRING];			// ^Cg o[ eLXg
HebiGame m_Hebi;
DisplayMode m_Display;
HMENU m_GameMenu;
BOOL FullScreen;

// ̃R[h W[Ɋ܂܂֐̑O錾:
ATOM			MyRegisterClass( HINSTANCE hInstance );
BOOL			InitInstance( HINSTANCE, int );
BOOL			InitGame( HWND , HINSTANCE );
BOOL			SetWindowSize( HWND , int , int);
BOOL			ChangeTimer( HWND , UINT , UINT , TIMERPROC );
BOOL			ChangeScreenMode( HWND , BOOL );
BOOL			MenuVisible( HWND , BOOL );
LRESULT CALLBACK	WndProc( HWND, UINT, WPARAM, LPARAM );
LRESULT CALLBACK	About( HWND, UINT, WPARAM, LPARAM );
LRESULT CALLBACK	Ranking( HWND, UINT, WPARAM, LPARAM );
VOID	CALLBACK	TimerProc( HWND ,  UINT , UINT , DWORD );


int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
 	// TODO: ̈ʒuɃR[hLqĂB
	MSG msg;
	HACCEL hAccelTable;

	// O[o XgO܂
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_HEBIGAME, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass( hInstance );

	// AvP[V̏s܂:
	if( !InitInstance( hInstance, nCmdShow ) ) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_HEBIGAME);

	// C bZ[W [v:
	while( GetMessage(&msg, NULL, 0, 0) ) 
	{
		if( !TranslateAccelerator (msg.hwnd, hAccelTable, &msg) ) 
		{
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
	}

	return msg.wParam;
}



//
//  ֐: MyRegisterClass()
//
//  pr: EBhE NX̓o^
//
//  Rg:
//
//    ̊֐т̎gp͂̃R[h Windows 95 Őɒǉꂽ
//    'RegisterClassEx' ֐ Win32 VXě݊ێꍇ
//    ̂ݕKvƂȂ܂BAvP[VAAvP[VɊ֘At
//    ꂽX[ ACR擾ł悤Å֐ĂяoƂ
//    dvłB
//
ATOM MyRegisterClass( HINSTANCE hInstance )
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style		= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon		= LoadIcon(hInstance, (LPCTSTR)IDI_HEBIGAME);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCSTR)IDC_HEBIGAME;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx( &wcex );
}

//
//   ֐: InitInstance(HANDLE, int)
//
//   pr: CX^X nh̕ۑƃC EBhE̍쐬
//
//   Rg:
//
//        ̊֐ł́ACX^X nhO[oϐɕۑAvO
//        C EBhE쐬\܂B
//
BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{
	HWND hWnd;

	hInst = hInstance; // O[oϐɃCX^X nhۑ܂

	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW ^ WS_THICKFRAME,
	  CW_USEDEFAULT, 0, CW_USEDEFAULT , 0 , NULL, NULL, hInstance, NULL);

	if( !hWnd ) 
	{
	  return FALSE;
	}
	m_GameMenu=GetMenu( hWnd );
	FullScreen=FALSE;
	//BGMp
	mciSendString( "open bgm.mid alias bgm",NULL,0,0);
	mciSendString( "play bgm NOTIFY" , NULL , 0 , hWnd );
	//j[AwWindow[hxON
	CheckMenuRadioItem( GetMenu( hWnd ) , IDM_WINDOW , IDM_FULLSCREEN , IDM_WINDOW , MF_BYCOMMAND  );
	//TCY
	SetWindowSize( hWnd,640,480);
	//Q[
	InitGame( hWnd , hInstance );
	//^C}[ݒu
	SetTimer( hWnd , 1 , StartTimer , (TIMERPROC)TimerProc );
	ShowWindow( hWnd, nCmdShow );
	UpdateWindow( hWnd );

	return TRUE;
}

//
//  ֐: WndProc(HWND, unsigned, WORD, LONG)
//
//  pr: C EBhẼbZ[W܂B
//
//  WM_COMMAND	- AvP[V j[̏
//  WM_PAINT	- C EBhE̕`
//  WM_DESTROY	- IbZ[W̒ʒmƃ^[
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	switch( message ) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// j[Ỉ:
			switch( wmId ) 
			{
				case IDM_ABOUT:
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   break;
				case IDM_EXIT:
				   DestroyWindow( hWnd );
				    break;
				/*case IDM_320:
					SetWindowSize( hWnd , 320 , 240 );
					break;
				case IDM_640:
					SetWindowSize( hWnd , 640 , 480 );
					break;
				case IDM_800:
					SetWindowSize( hWnd , 800 , 600 );
					break;
				case IDM_1024:
					SetWindowSize( hWnd , 1024 , 768 );
					break;*/
				case IDM_WINDOW:
					CheckMenuRadioItem( GetMenu( hWnd ) , IDM_WINDOW , IDM_FULLSCREEN , IDM_WINDOW , MF_BYCOMMAND  );
					if(FullScreen) ChangeScreenMode( hWnd , FALSE );
					break;
				case IDM_FULLSCREEN:
					CheckMenuRadioItem( GetMenu( hWnd ) , IDM_WINDOW , IDM_FULLSCREEN , IDM_FULLSCREEN , MF_BYCOMMAND  );
					if(!FullScreen) ChangeScreenMode( hWnd , TRUE );
					break;
				case IDM_CLRANK:
					if(MessageBox( hWnd , "LO܂B\n낵łH" , "LO" , MB_YESNO )==IDYES )
						m_Hebi.m_Rank.ClearRanking();
				/*case IDM_HIGHSPEED:
					CheckMenuRadioItem( GetMenu( hWnd ) , IDM_HIGHSPEED , IDM_LOWSPEED , IDM_HIGHSPEED , MF_BYCOMMAND  );
					ChangeTimer( hWnd , 1 , 50 , (TIMERPROC)TimerProc );
					break;
				case IDM_NORMALSPEED:
					CheckMenuRadioItem( GetMenu( hWnd ) , IDM_HIGHSPEED , IDM_LOWSPEED , IDM_NORMALSPEED , MF_BYCOMMAND  );
					ChangeTimer( hWnd , 1 , 100 , (TIMERPROC)TimerProc );
					break;
				case IDM_LOWSPEED:
					CheckMenuRadioItem( GetMenu( hWnd ) , IDM_HIGHSPEED , IDM_LOWSPEED , IDM_LOWSPEED , MF_BYCOMMAND  );
					ChangeTimer( hWnd , 1 , 200 , (TIMERPROC)TimerProc );
					break;*/
				default:
				   return DefWindowProc( hWnd, message, wParam, lParam );
			}
			break;
		//L[{[h̓
		case WM_KEYDOWN:
			switch ((int)wParam){
			case VK_UP:
				if(m_Hebi.GetPlayMode()==PLAYMODE_PLAY && m_Hebi.GetDirection()!=HEBI_DIRECTION_UP && m_Hebi.CanMove( HEBI_DIRECTION_UP )  )
					m_Hebi.Set(m_Hebi.GetX(),m_Hebi.GetY(),HEBI_DIRECTION_UP);
				break;
			case VK_RIGHT:
				if(m_Hebi.GetPlayMode()==PLAYMODE_PLAY && m_Hebi.GetDirection()!=HEBI_DIRECTION_RIGHT && m_Hebi.CanMove( HEBI_DIRECTION_RIGHT )  )
					m_Hebi.Set(m_Hebi.GetX(),m_Hebi.GetY(),HEBI_DIRECTION_RIGHT);
				break;
			case VK_DOWN:
				if(m_Hebi.GetPlayMode()==PLAYMODE_PLAY && m_Hebi.GetDirection()!=HEBI_DIRECTION_DOWN && m_Hebi.CanMove( HEBI_DIRECTION_DOWN )  )
					m_Hebi.Set(m_Hebi.GetX(),m_Hebi.GetY(),HEBI_DIRECTION_DOWN);
				break;
			case VK_LEFT:
				if(m_Hebi.GetPlayMode()==PLAYMODE_PLAY && m_Hebi.GetDirection()!=HEBI_DIRECTION_LEFT && m_Hebi.CanMove( HEBI_DIRECTION_LEFT ) )
					m_Hebi.Set(m_Hebi.GetX(),m_Hebi.GetY(),HEBI_DIRECTION_LEFT);
				break;
			case VK_SPACE:
				switch (m_Hebi.GetPlayMode()){
				case PLAYMODE_PLAY:
					m_Hebi.SetPlayMode( PLAYMODE_PAUSE );
					mciSendString( "stop bgm" , NULL , 0 , NULL );
					break;
				case PLAYMODE_GAMEOVER:
					//̂̐O
					m_Hebi.SubHebi(MAX_HEBI);
					//ʒu
					m_Hebi.Set( 0 , 0 , HEBI_DIRECTION_DOWN ); 
					//XRAO
					m_Hebi.SetScore(0);
					m_Hebi.SetSpeed(StartTimer);
					ChangeTimer( hWnd , 1 , m_Hebi.GetSpeed() , (TIMERPROC)TimerProc );
					mciSendString( "seek bgm to start",NULL , 0 , NULL );
				case PLAYMODE_PAUSE:
					m_Hebi.SetPlayMode( PLAYMODE_PLAY );
					mciSendString( "play bgm NOTIFY" , NULL , 0 , hWnd );
					break;
				}
				break;
			}
		case WM_PAINT:
			hdc = BeginPaint (hWnd, &ps);
			// TODO: ̈ʒuɕ`p̃R[hǉĂ...
			//DrawText( hdc, szHello, strlen(szHello), &rt, DT_CENTER );
			m_Hebi.Up( hWnd , hdc );
			EndPaint( hWnd, &ps );
			break;
		case WM_DESTROY:
			//^C}[j
			KillTimer( hWnd , 1 );
			mciSendString( "stop bgm" , NULL , 0 , NULL );
			mciSendString( "close bgm" , NULL , 0 , NULL );
			PostQuitMessage( 0 );
			break;
		case MM_MCINOTIFY:
			//BGMtIAēxĐ
			if(m_Hebi.GetPlayMode()==PLAYMODE_PLAY){
				mciSendString( "seek bgm to start",NULL , 0 , NULL );
				mciSendString( "play bgm NOTIFY" , NULL , 0 , hWnd );
			}
			break;
		case WM_MOUSEMOVE:
			if(!FullScreen)
				break;
			if(HIWORD(lParam)<15)
				MenuVisible( hWnd , TRUE );
			else
				if(GetMenu(hWnd)!=NULL ) MenuVisible( hWnd , FALSE );
			break;
		default:
			return DefWindowProc( hWnd, message, wParam, lParam );
   }
   return 0;
}

// o[W{bNXpbZ[W nh
LRESULT CALLBACK About( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	switch( message )
	{
		case WM_INITDIALOG:
				return TRUE;

		case WM_COMMAND:
			if( LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL ) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

// LO{bNXpbZ[W nh
LRESULT CALLBACK Ranking( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	HWND EditWnd;
	HWND StaticWnd;
	switch( message )
	{
		case WM_INITDIALOG:
			EditWnd=GetDlgItem(hDlg, IDC_RANKING);
			StaticWnd=GetDlgItem( hDlg , IDC_LABEL);
			SendMessage(EditWnd, EM_LIMITTEXT, 20, 0);
			char s[100];
			sprintf( s, "Ȃ%dʂłB",m_Hebi.m_Rank.GetRank( m_Hebi.GetScore() ) );
			SetWindowText( hDlg , s );
			sprintf( s, "Ȃ̋L^͏%dʈȓɓ܂I\nOc܂B\nO͂ĉB",MAX_RANKING );
			SendMessage(StaticWnd, WM_SETTEXT, 0, (LPARAM)s);
			//SetWindowText( StaticWnd , s );
			return TRUE;

		case WM_COMMAND:
			if( LOWORD(wParam) == IDOK ) 
			{
				EditWnd=GetDlgItem(hDlg, IDC_RANKING);
				char s[21];
				SendMessage(EditWnd, WM_GETTEXT, 21, (LPARAM)s);
				if( strlen( s )==0 )
					strcpy( s , "No Name" );
				m_Hebi.m_Rank.SetRanking( m_Hebi.GetScore() , m_Hebi.GetNumber() , s );
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
//^C}[p
VOID CALLBACK TimerProc( HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime )
{
	static DWORD tcount;
	static int tm;
	//~ĂȂ
	if(m_Hebi.GetPlayMode()==PLAYMODE_PLAY){
		//ւт𓮂
		m_Hebi.Move();
		//̂ɏՓ˂
		if(!m_Hebi.CheckCollide()){
			m_Hebi.SetPlayMode( PLAYMODE_GAMEOVER );
			mciSendString( "stop bgm" , NULL , 0 , NULL );
			if(m_Hebi.m_Rank.GetRank( m_Hebi.GetScore() ))
				DialogBox(hInst, (LPCTSTR)IDD_RANKING, hwnd, (DLGPROC)Ranking);
			tcount=0;
			//MessageBox( hwnd , "Q[I[o[" , "ւуQ[" , NULL );
		}
		// 莞ԂŃACeč\
		////////////////////      Level 4      ////////////////////   
		if( tcount + 10000 <= GetTickCount() ){	
			m_Hebi.ReCreateItem();					// ACëʒuύX
			m_Hebi.TekiMove();						// Gׂ֓
		////////////////////      Level 5-2      ////////////////////   
			m_Hebi.SubSpeed( 10 );					// ʂ̓PO~b
			ChangeTimer( hwnd , 1 , m_Hebi.GetSpeed() , (TIMERPROC)TimerProc );
			tcount=GetTickCount();		
		}
		// 莞ԂœG𓮂
		tm++;
		if( tm>5 ){
			m_Hebi.TekiMove();
			tm=0;
		}
	}
	//ĕ`悳
	RedrawWindow( hwnd , NULL , NULL , RDW_INTERNALPAINT || RDW_UPDATENOW);
}

//EChẼTCYNCAgύX
BOOL SetWindowSize( HWND hWnd , int Width ,int Height)
{
	RECT ws,cs;
	//Ŝ̑傫擾
	GetWindowRect( hWnd , &ws );
	//NCAg̑傫擾
	GetClientRect( hWnd , &cs );
	//Ś|NCAg{wTCY
	ws.right = ws.right - ( ws.left+cs.right ) + Width ;
	ws.bottom = ws.bottom - ( ws.top + cs.bottom ) + Height ;
	//ύXTCYݒ
	SetWindowPos( hWnd , NULL , 0 , 0 , ws.right , ws.bottom , SWP_NOZORDER | SWP_NOMOVE );
	return TRUE;
}

//Q[
BOOL InitGame( HWND hWnd ,HINSTANCE hInstance)
{
	HDC hdc=GetDC( hWnd );
	Bitmap w;
	m_Hebi.SetBack( hdc , 640 , 480 );
	m_Hebi.SetTile( hdc , LoadBitmap( hInstance , (char*)IDB_BACKTILE ) , 32 , 32 );
	w.SetBitmap( hdc , LoadBitmap( hInstance , (char*)IDB_ITEMS) , 64 , 64 );
	m_Hebi.SetHebiImage( w );
	w.Destroy();
	ReleaseDC( hWnd , hdc );
	return TRUE;
}

BOOL ChangeTimer( HWND hWnd , UINT id , UINT t , TIMERPROC timerproc )
{
	KillTimer( hWnd , id );
	SetTimer( hWnd , id , t , timerproc );
	return TRUE;
}

BOOL ChangeScreenMode( HWND hWnd , BOOL f )
{
	long s= GetWindowLong( hWnd , GWL_STYLE );
	static RECT r;
	FullScreen=f;
	MenuVisible( hWnd , !f );
	SetWindowLong( hWnd, GWL_STYLE, s ^ WS_CAPTION );
	if(f){
		GetWindowRect( hWnd , &r );
		SetWindowPos( hWnd , NULL , 0 , 0 , 640 , 480 , SWP_NOZORDER );
		m_Display.ChangeDisplayMode( 640 , 480 , 16 );
	}else{
		m_Display.ChangeDisplayMode();
		SetWindowPos( hWnd , NULL , r.left , r.top , r.right-r.left,r.bottom-r.top  , SWP_NOZORDER | SWP_DRAWFRAME );
	}
	return TRUE;
}

BOOL MenuVisible( HWND hWnd , BOOL f )
{
	if(f)
		SetMenu( hWnd , m_GameMenu );
	else 
		SetMenu( hWnd , NULL );
	SetWindowSize( hWnd , 640 , 480 );
	return TRUE;
}
